/*
 * Decompiled with CFR 0.152.
 */
package dev.yumi.mc.core.impl.neoforge;

import dev.yumi.commons.function.YumiPredicates;
import dev.yumi.mc.core.impl.neoforge.NeoForgeFileAttributeView;
import dev.yumi.mc.core.impl.neoforge.NeoForgeFileAttributes;
import dev.yumi.mc.core.impl.neoforge.NeoForgeFileSystem;
import dev.yumi.mc.core.impl.neoforge.NeoForgePath;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.neoforged.fml.jarcontents.JarResourceAttributes;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeFileSystemProvider
extends FileSystemProvider {
    public static final NeoForgeFileSystemProvider INSTANCE = new NeoForgeFileSystemProvider();

    @Override
    public String getScheme() {
        return "yumi.virtual.neoforge";
    }

    @Override
    public FileSystem newFileSystem(URI uri, Map<String, ?> env) {
        throw new UnsupportedOperationException("Only direct creation is supported.");
    }

    @Override
    public FileSystem getFileSystem(URI uri) {
        throw new UnsupportedOperationException("Only direct creation is supported.");
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        throw new UnsupportedOperationException("This method should not be called directly; use Path.of(URI) instead.");
    }

    @Override
    public boolean exists(Path path, LinkOption ... options) {
        NeoForgePath actualPath = (NeoForgePath)path;
        return actualPath.getFileSystem().resolveEntry(actualPath) != null;
    }

    @Override
    public InputStream newInputStream(Path path, OpenOption ... options) throws IOException {
        NeoForgeFileSystem.Entry entry;
        NeoForgePath actualPath = (NeoForgePath)path;
        NeoForgeFileSystem.Entry entry2 = entry = actualPath.getFileSystem().resolveEntry(actualPath);
        int n = 0;
        return (switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NeoForgeFileSystem.File.class, NeoForgeFileSystem.Directory.class}, (Object)entry2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> (NeoForgeFileSystem.File)entry2;
            case 1 -> {
                NeoForgeFileSystem.Directory dir = (NeoForgeFileSystem.Directory)entry2;
                throw new FileNotFoundException("Cannot find file: " + String.valueOf(actualPath));
            }
            case -1 -> throw new FileNotFoundException("Cannot find file: " + String.valueOf(actualPath));
        }).resource().open();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public SeekableByteChannel newByteChannel(Path path, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        NeoForgeFileSystem.Entry entry;
        if (options.contains(StandardOpenOption.WRITE) || options.contains(StandardOpenOption.APPEND)) {
            this.checkWritable();
        }
        NeoForgePath actualPath = (NeoForgePath)path;
        NeoForgeFileSystem.Entry entry2 = entry = actualPath.getFileSystem().resolveEntry(actualPath);
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{NeoForgeFileSystem.File.class, NeoForgeFileSystem.Directory.class}, (Object)entry2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                NeoForgeFileSystem.File file = (NeoForgeFileSystem.File)entry2;
                return new SeekableInMemoryByteChannel(file.resource().readAllBytes());
            }
            case 1: {
                NeoForgeFileSystem.Directory dir = (NeoForgeFileSystem.Directory)entry2;
                throw new FileNotFoundException("Cannot find file: " + String.valueOf(actualPath));
            }
            case -1: 
        }
        throw new FileNotFoundException("Cannot find file: " + String.valueOf(actualPath));
    }

    @Override
    public DirectoryStream<Path> newDirectoryStream(final Path dir, final @Nullable DirectoryStream.Filter<? super Path> filter) throws IOException {
        NeoForgePath path = (NeoForgePath)dir;
        NeoForgeFileSystem.Entry entry = path.getFileSystem().resolveEntry(path);
        if (!(entry instanceof NeoForgeFileSystem.Directory)) {
            throw new NotDirectoryException(path.toString());
        }
        final NeoForgeFileSystem.Directory directory = (NeoForgeFileSystem.Directory)entry;
        return new DirectoryStream<Path>(this){

            @Override
            @NotNull
            public Iterator<Path> iterator() {
                Stream<Path> stream = directory.entries().values().stream().map(NeoForgeFileSystem.Entry::name).map(dir::resolve);
                if (filter != null) {
                    stream = stream.filter(path -> {
                        try {
                            return filter.accept(path);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                return stream.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    @Override
    public void createDirectory(Path dir, FileAttribute<?> ... attrs) {
        this.checkWritable();
    }

    @Override
    public void delete(Path path) {
        this.checkWritable();
    }

    @Override
    public void copy(Path source, Path target, CopyOption ... options) throws IOException {
        throw new UnsupportedOperationException("Cannot copy files.");
    }

    @Override
    public void move(Path source, Path target, CopyOption ... options) {
        throw new UnsupportedOperationException("Cannot move files.");
    }

    @Override
    public boolean isSameFile(Path a, Path b) {
        if (b == null || a.getFileSystem() != b.getFileSystem()) {
            return false;
        }
        return a.normalize().toAbsolutePath().equals(b.normalize().toAbsolutePath());
    }

    @Override
    public boolean isHidden(Path path) {
        return false;
    }

    @Override
    public FileStore getFileStore(Path path) {
        return null;
    }

    @Override
    public void checkAccess(Path path, AccessMode ... modes) {
    }

    @Override
    public <V extends FileAttributeView> V getFileAttributeView(Path path, Class<V> type, LinkOption ... options) {
        if (type == null) {
            throw new NullPointerException();
        }
        if (type == BasicFileAttributeView.class) {
            return (V)new NeoForgeFileAttributeView((NeoForgePath)path);
        }
        return null;
    }

    @Override
    public <A extends BasicFileAttributes> A readAttributes(Path path, Class<A> type, LinkOption ... options) throws IOException {
        if (type == BasicFileAttributes.class) {
            return (A)this.readBasicAttributes((NeoForgePath)path);
        }
        throw new UnsupportedOperationException("Attributes of type " + type.getName() + " not supported");
    }

    BasicFileAttributes readBasicAttributes(NeoForgePath path) throws IOException {
        JarResourceAttributes jarResourceAttributes;
        NeoForgeFileSystem.Entry entry = path.getFileSystem().resolveEntry(path);
        if (entry == null) {
            throw new NoSuchFileException(path.toString());
        }
        if (entry instanceof NeoForgeFileSystem.File) {
            NeoForgeFileSystem.File file = (NeoForgeFileSystem.File)entry;
            jarResourceAttributes = file.resource().attributes();
        } else {
            jarResourceAttributes = null;
        }
        return new NeoForgeFileAttributes(entry, jarResourceAttributes);
    }

    @Override
    public Map<String, Object> readAttributes(Path path, String attributes, LinkOption ... options) throws IOException {
        String attrs;
        String view;
        int colonPos = attributes.indexOf(58);
        if (colonPos == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, colonPos++);
            attrs = attributes.substring(colonPos);
        }
        if (!view.equals("basic")) {
            throw new UnsupportedOperationException("View <" + view + "> is not supported.");
        }
        Predicate<String> parsedAttrs = this.parseAttributes(attrs);
        BasicFileAttributes readAttributes = this.readBasicAttributes((NeoForgePath)path);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.appendAttributes(map, parsedAttrs, "size", readAttributes::size);
        this.appendAttributes(map, parsedAttrs, "creationTime", readAttributes::creationTime);
        this.appendAttributes(map, parsedAttrs, "lastAccessTime", readAttributes::lastAccessTime);
        this.appendAttributes(map, parsedAttrs, "lastModifiedTime", readAttributes::lastModifiedTime);
        this.appendAttributes(map, parsedAttrs, "isDirectory", readAttributes::isDirectory);
        this.appendAttributes(map, parsedAttrs, "isRegularFile", readAttributes::isRegularFile);
        this.appendAttributes(map, parsedAttrs, "isSymbolicLink", readAttributes::isSymbolicLink);
        this.appendAttributes(map, parsedAttrs, "isOther", readAttributes::isOther);
        this.appendAttributes(map, parsedAttrs, "fileKey", readAttributes::fileKey);
        return map;
    }

    private Predicate<String> parseAttributes(String attrs) {
        if (attrs.equals("*")) {
            return YumiPredicates.alwaysTrue();
        }
        Set<String> set = Set.of(attrs.split(","));
        return set::contains;
    }

    private void appendAttributes(Map<String, Object> map, Predicate<String> attrs, String attr, Supplier<Object> data) {
        if (attrs.test(attr)) {
            map.put(attr, data.get());
        }
    }

    @Override
    public void setAttribute(Path path, String attribute, Object value, LinkOption ... options) {
        this.checkWritable();
    }

    private void checkWritable() {
        throw new ReadOnlyFileSystemException();
    }
}

